$(window).load(function()
{
    var WIDTH = 600;
    var HEIGHT = 600;

    var PLANET_POSITION_X = WIDTH / 2;
    var PLANET_POSITION_Y = HEIGHT / 2;

    var scalePlanetArray = new Array(60, 20, 50, 40);
    var massPlanetArray = new Array(5.98e24, 7.35e22, 4.87e24, 0.33e24);
    var colorPlanetArray = new Array('blue', 'silver', 'brown', 'red');

    var circle = null;
    var planet = null;

    var distance = 1;

    var valueG = 6.67e11;
    var valueM = $("#massValue").text();
    var R_SCALE = 1;

    var whichG = 0;

    var ctrlPressed = false;

    var currentEnergy = 0;
    var plot = null;
    var plotData = [];
    var plotX = [];

    function drawCircle(xPosition, yPosition)
    {
        circle = new Kinetic.Circle(
            {
                x: xPosition,
                y: yPosition,
                radius: $("#massValue").val() / 45 + 5,
                fill: 'black',
                stroke: 'black',
                strokeWidth: 1,
                draggable: true,
                dragBoundFunc: function(pos)
                {
                    var newX = pos.x;
                    var newY = pos.y;

                    if(ctrlPressed == true)
                    {
                        var scale = distance / Math.sqrt(Math.pow(pos.x - PLANET_POSITION_X, 2) + Math.pow(pos.y - PLANET_POSITION_Y, 2));
                        newY = Math.round((pos.y - PLANET_POSITION_Y) * scale + PLANET_POSITION_Y);
                        newX = Math.round((pos.x - PLANET_POSITION_X) * scale + PLANET_POSITION_X);
                    }
                    else
                    {
                        if(distance < scalePlanetArray[whichG])
                        {
                            
                        }
                    }

                    return {
                        x: newX,
                        y: newY
                    };
                }
            });

        // ------------ DRAG AND DROP ------------
        circle.on('dragstart', function()
        {
            calcEnergy();
        });

        circle.on('dragmove', function()
        {
            calcEnergy();
        });

        circle.on('dragend', function()
        {
            calcEnergy();
        });

        // ------------ CURSOR --------------
        circle.on('mouseover', function()
        {
            document.body.style.cursor = 'pointer';
        });

        circle.on('mouseout', function()
        {
            document.body.style.cursor = 'default';
        })

        calcEnergy();

        layer.add(circle);
        layer.draw();
    }

    function nearestPoint(realDistance)
    {
        realDistance = parseInt(realDistance.toFixed(0));
        return plotX.indexOf(realDistance);
    }

    function calcEnergy()
    {
        if(circle != null)
        {
            var positionX = circle.getPosition().x;
            var positionY = HEIGHT - circle.getPosition().y;

            // Dystans
            distance = (Math.sqrt(Math.pow(positionX - PLANET_POSITION_X, 2) + Math.pow(positionY - PLANET_POSITION_Y, 2))).toFixed(2);
            var realDistance = distance * R_SCALE;
            currentEnergy = 0 - ( (valueM * valueG * massPlanetArray[whichG]) / realDistance  / Math.pow(10, 35)).toFixed(2);
            if(plot != null)
            {
                if(ctrlPressed == false)
                {
                    if (distance >= scalePlanetArray[whichG])
                    {
                    plot.unhighlight();
                    // Ktory punkt jest najblizej?
                    plot.highlight(0, nearestPoint(realDistance));}
                }
            }
            if(ctrlPressed == false)
            {
                if(distance >= scalePlanetArray[whichG])
                    $("#energyValue").text(currentEnergy).css("color", "black").css("font-size", "32px");
                else
                    $("#energyValue").text("Model zmian energii potencjalnej nie jest spełniony dla wnętrza źródła pola grawitacyjnego.").css("color", "red").css("font-size", "20px");
            }
        }
		$("#rValue").text(realDistance);
        layer.draw();
    }

    function drawPlanet()
    {
        if(planet == null)
        {
            planet = new Kinetic.Circle(
                {
                    x: PLANET_POSITION_X,
                    y: PLANET_POSITION_Y,
                    radius: scalePlanetArray[whichG],
                    fill: colorPlanetArray[whichG],
                    stroke: 'black',
                    strokeWidth: 2,
                    draggable: false
                });

            layer.add(planet);
        }
        else
        {
            planet.setRadius(scalePlanetArray[whichG]);
            planet.setFill(colorPlanetArray[whichG]);
        }

        layer.draw();
    }

    function showMsg(msg)
    {
        $("#message").hide();
        $("#message").html(msg);
        $("#message").show("slow");
    }

    function createData()
    {
        plotData = [];
        plotX = [];
        for (var i = 1; i < 300; i += 1) 
        {
            yValue = 0 - ( (valueM * valueG * massPlanetArray[whichG]) / i / Math.pow(10, 35)).toFixed(2);
          //  plotData.push([(i + scalePlanetArray[whichG]), yValue]);
            // plotX.push((i + scalePlanetArray[whichG]));
            plotData.push([(i), yValue]);
             plotX.push((i ));
        }
    }

    function drawPlot()
    {
        var yValue = 0;
        createData();

        if (whichG == 1 || whichG == 3) {
            plot = $.plot("#chart", [
                { data: plotData, label: "E [MJ]" }
            ], {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        //show: true
                    },
                    color: 'blue'
                },
                grid: {
                    //hoverable: true
                },
                xaxis: {
                    min: 0,
                    max: 200,
                    position: "top"
                },
                yaxis: {
                    min: -10,

                    max: 0,
                    ticks: false
                }
            });
        }
        if (whichG == 0 || whichG == 2) {
            plot = $.plot("#chart", [
                { data: plotData, label: "E [MJ]" }
            ], {
                series: {
                    lines: {
                      //  color: rgb( 64,154,221),
                        show: true
                    },
                    points: {
                        //show: true
                    },
                   color: 'blue'
                },
                grid: {
                    //hoverable: true
                },
                xaxis: {
                    min: 0,
                    max: 200,
                    position: "top"
                },
                yaxis: {
                    min: -200,

                    max: 0,
                    ticks: false
                }
               
            });
        }
    }

    // xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

    $(window).keydown(function(evt)
    {
        if (evt.which == 17)
        {
            ctrlPressed = true;
        }
    })
    .keyup(function(evt)
    {
        if (evt.which == 17)
        {
            ctrlPressed = false;
        }
    });

    // xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

    var stage = new Kinetic.Stage(
        {
            container: 'pole',
            width: WIDTH,
            height: HEIGHT
        });

    stage.getContent().addEventListener('click', function(evt)
    {
        evt.preventDefault();
        if(circle == null)
        {
            var mouseXY = stage.getPointerPosition();
            var canvasX = mouseXY.x;
            var canvasY = mouseXY.y;
            drawCircle(canvasX, canvasY);
            $("#properties").show();
            drawPlot();
            showMsg("Trzymaj wciśnięty przycisk CTRL podczas przesuwania ciała, aby poruszać nim wyłącznie po jednakowym okręgu.");
        }
    });

    var layer = new Kinetic.Layer();
    stage.add(layer);

    // ============== DOMYSLNA PLANETA ======================
    drawPlanet();

    // xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

    $("#mass").change(function()
    {
        var newval = $(this).val();
        $("#massValue").text(newval);
        valueM = newval;
        if(circle != null)
        {
            calcEnergy();
            //circle.setRadius($("#massValue").val() / 10 + 5);
        }
    });

    // ============================= ZMIANA PLANET =======================

    $(function()
    {
        $( "#planets" ).buttonset();
    });

    $("input[name='planet']").on("change", function ()
    {
        whichG = this.value;
        drawPlanet();
        if(circle != null)
        {
            calcEnergy();
            createData();
            plot.draw();
        }
        drawPlot();

    });

    // xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

    showMsg("Kliknij myszką w dowolny punkt pola grawitacyjnego, aby wprowadzić ciało.");
});

